#!/usr/bin/perl
#
# Uses Tass::Control::Driver directly to set and read all dacs on the system
#
# $Name:  $
#
# $Log: adc.pl,v $
# Revision 1.1  2005/01/16 03:36:50  robert
# *** empty log message ***
#
# Revision 0.1.1.1  2002/11/03 02:53:17  robert
#
#

use strict;
use warnings;

use Time::HiRes qw(sleep gettimeofday tv_interval time);
use Log::Agent;
use Log::Agent::Rotate;
use Log::Agent::Priorities qw( :LEVELS );
require Log::Agent::Driver::File;
require Log::Agent::Tag::Callback;

logconfig(
           -driver => Log::Agent::Driver::File->make(
                                        -prefix   => 'TD',
                                        -showpid  => 1,
                                        -rotate   => Log::Agent::Rotate->make(),
                                        -channels => {
                                                       'error'  => 'adc.err',
                                                       'output' => 'adc.out',
                                                       'debug'  => 'adc.dbg'
                                        }
           ),
           -trace => INFO
);

my %dacs = (
             0  => 6,
             1  => -3,
             2  => 0,
             3  => 7,
             4  => 2,
             5  => 3,
             6  => -8,
             7  => 3.9,
             8  => 0,
             9  => 0,
             10 => 6,
             11 => 7,
             12 => .2,
             13 => 9,
             14 => 10,
             15 => 10
);

my %adcs = (
             0  => "Water Temp   ",
             1  => "VCO Temp     ",
             2  => "VCO Reference",
             3  => "Temp 1       ",
             4  => "Temp 2       ",
             5  => "Temp 3       ",
             6  => "Temp C0 DAC15",
             7  => "Temp C3 DAC10",
             8  => "Ground       ",
             9  => "-15          ",
             10 => "-5           ",
             11 => "+5           ",
             12 => "+15          ",
             13 => "VCO     DAC12",
             14 => "Temp C1 DAC14",
             15 => "Temp C2 DAC11",
             16 => "CCD Temp 2   ",
             17 => "CCD VDD Power",
             18 => "CCD Temp 0   ",
             19 => "CCD Temp 1   ",
             20 => "ADC Reference",
             21 => "VVH     DAC 7",
             22 => "VRH     DAC 2",
             23 => "VHL     DAC 1",
             24 => "TEC Current 2",
             25 => "TEC Current 0",
             26 => "TEC Current 1",
             27 => "TEC Current 3",
             28 => "TEC Power    ",
             29 => "VVL     DAC 6",
             30 => "VRL     DAC 3",
             31 => "VHH     DAC 0"
);

use TASS::Control::Driver;
my $tc =
   TASS::Control::Driver->new( ( 'port' => '/dev/ttyS0', 'baud' => '9600' ) );

$tc->start;

#
# Write the dac values wet up in the hash above
map { $tc->write_dac( $_, $dacs{ $_ } ) } 0 .. 15;

#
# Read the dac values once every minute and print the results.
for ( 1 .. 1 )
   {
   map {
      printf "ADC_%02d %8.3f %s\n", $_, ( $tc->read_adc( $_ ) )[ 1 ],
         $adcs{ $_ };
   } sort { $a <=> $b } keys %adcs;
   sleep 60;
   }
