#!/usr/bin/perl
#
# Moves all mechs to their 'home' positions, sitting on their limit flags
# and then moves RA to level.
#
# $Name:  $
#
# $Log: home.pl,v $
# Revision 1.1  2005/01/16 03:36:51  robert
# *** empty log message ***
#
# Revision 1.1  2003/01/25 19:20:23  robert
# *** empty log message ***
#
# Revision 0.1.1.1  2002/11/03 02:53:17  robert
#
#

use strict;
use warnings;

use Time::HiRes qw(sleep gettimeofday tv_interval time);
use Log::Agent;
use Log::Agent::Rotate;
use Log::Agent::Priorities qw( :LEVELS );
use Log::Agent::Driver::File;
use Astro::Sunrise;
use Class::Date qw( date localdate );

logconfig(
   -driver => Log::Agent::Driver::File->make(
      -prefix  => 'TC',
      -showpid => 1,
      -rotate  => Log::Agent::Rotate->make(
                                           -unzipped => 3,
                                           -backlog  => 3,
                                           -max_size => 1_000_000,
      ),

      #-channels => { 'error' => 'night.err',
      #    'output' => 'night.out',
      #    'debug' => 'night.dbg' } ),
      -channels => {
                     'error'  => 'home.out',
                     'output' => 'home.out',
                     'debug'  => 'home.out'
      }
   ),
   -level => INFO
);

use TASS::Control;
my $tc = TASS::Control->new( '/tass/data/daily/tass-control.cfg' );

$tc->start;
$tc->dac_end;
$tc->init_telescope;

printf "Dec %d from limit\n", $tc->dec_drive_to_limit;
printf "RA  %d from limit\n", $tc->ra_to_limit;
printf "V   %d from limit\n", $tc->focus_0_to_limit;
printf "I   %d from limit\n", $tc->focus_1_to_limit;
$tc->ra_to_meridian;
