#!/usr/bin/perl
#
# $Name:  $
#
# $Log: test_camera.pl,v $
# Revision 0.2  2005/01/16 03:29:36  robert
# *** empty log message ***
#
# Revision 0.1.1.1  2002/11/03 02:53:17  robert
#
#

use strict;
use warnings;

use Time::HiRes qw(sleep gettimeofday tv_interval time);
use Log::Agent;
use Log::Agent::Priorities qw( :LEVELS );
require Log::Agent::Driver::File;
require Log::Agent::Tag::Callback;
use TASS::Control::Driver;

logconfig(
           -driver => Log::Agent::Driver::File->make(
                                -prefix   => 'TD',
                                -showpid  => 1,
                                -channels => {
                                               'error'  => 'test_camera.err',
                                               'output' => 'test_camera.out',
                                               'debug'  => 'test_camera.dbg'
                                }
           ),
           -debug => INFO
);

sub inb
   {
   my $command = '/tass/src/downfits/inb ' . shift;
   my $result  = `$command`;
   chomp $result;
   return $result;
   }

sub outb
   {
   my $command = '/tass/src/downfits/outb ' . join ' ', @_;
   return `$command`;
   }

my $tc =
   TASS::Control::Driver->new( ( 'port' => '/dev/ttyS0', 'baud' => '9600' ) );
$tc->start;
$tc->load_register( 'MPX', 0 );

my $add = '0x300';

#
# Test block done
#print 'Before first clear, status register is ' . inb( $add ) . "\n";
#outb( $add, 0x01 );
#print 'At start, status register is           ' . inb( $add ) . "\n";
#$tc->pulse( 16 );
#print 'After block done, status register is   ' . inb( $add ) . "\n";
#outb( $add, 0x01 );
#print 'After clear, status register is ' . inb( $add ) . "\n";

#
# Test block done set by scan
$tc->pulse( 4 );

my $status;
my $count = 1;

while ( !( oct( $status = inb( $add ) ) & 0x80 ) )
   {
   print "$count Status is $status\n";
   sleep 1;
   ++$count;
   }

print "$count Status is $status\n";
