use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
WriteMakefile(
    'NAME'     => 'TASS::Control',
    'VERSION'   => '0.94',
    'PREREQ_PM'      => {
                          Astro::FITS::CFITSIO => 0,
                          Astro::Time => 0,
                          Astro::Sunrise => 0,
                          Callback => 0,
                          Carp => 0,
                          Class::MethodMaker => 0,
                          Class::Date => 0,
                          Config::IniFiles => 0,
                          Device::SerialPort => 0,
                          Log::Agent => 0,
			  Log::Agent::Priorities => 0,
			  Log::Agent::Rotate => 0,
			  Log::Agent::Tag::Callback => 0,
                          Pod::Tests => 0,
                          Proc::Fork => 0,
			  Test::More => 0,
                          DateTime => 0,
                          Time::HiRes => 0,
                        }, # e.g., Module::Name => 1.1
    ($] >= 5.005 ?    ## Add these new keywords supported since 5.005
      ( ABSTRACT_FROM => 'lib/TASS/Control.pm', # retrieve abstract from module
       AUTHOR     => 'Robert Creager <Robert at LogicalChaos.org>') : ()),
);

    {
    package MY;
    sub top_targets {
       my($self) = @_;
       my $out = "POD2TEST_EXE = pod2test\n";

       $out .= $self->SUPER::top_targets(@_);
       $out =~ s/^(pure_all\b.*)/$1 testifypods/m;

       $out .= "\n\ntestifypods : \n";

       foreach my $pod (keys %{$self->{MAN1PODS}}, keys %{$self->{MAN3PODS}})
          {
          next if $pod =~ /Server/;
          (my $test = $pod) =~ s/\.(pm|pod)$//;
          $test =~ s|/|-|g;
          $test =~ s/^lib\W//;
          $test =~ s/\W/-/;
          $test = "embedded-$test.t";
          $out .= "\t$self->{NOECHO}\$(POD2TEST_EXE) ".
          "$pod t/$test\n";
          }
       return $out;
       }
    }
