#!/usr/bin/perl
#
# Used to help align the scope.  Some day, will be automated and guide the
# user through the alignment
#
# $Name:  $
#
# $Log: align.pl,v $
# Revision 1.1  2005/01/16 03:36:50  robert
# *** empty log message ***
#
# Revision 1.1  2003/01/25 19:20:23  robert
# *** empty log message ***
#
# Revision 0.1.1.1  2002/11/03 02:53:17  robert
#
#

use strict;
use warnings;

use Time::HiRes qw(sleep gettimeofday tv_interval time);
use Log::Agent;
use Log::Agent::Rotate;
use Log::Agent::Priorities qw( :LEVELS );
use Log::Agent::Driver::File;
use Term::ReadKey;

logconfig(
           -driver => Log::Agent::Driver::File->make(
                                 -prefix  => 'TC',
                                 -showpid => 1,
                                 -rotate  => Log::Agent::Rotate->make(
                                                         -unzipped => 3,
                                                         -backlog  => 3,
                                                         -max_size => 1_000_000,
                                 ),
                                 -channels => {
                                                'error'  => 'align.out',
                                                'output' => 'align.out',
                                                'debug'  => 'align.out'
                                 }
           ),
           -level => INFO
);

use TASS::Control;
my $tc = TASS::Control->new( './tass-control.cfg' );

$tc->start;
$tc->init_telescope;

my $mech = 'ra';
my $key = '';
my $cmd;
my $ra_speed = 3;

ReadMode 3;
while( $key ne 'q' )
   {
   $key = ReadKey 0;
   SWITCH: for ( $key )
      {
      /r/ && do { $mech = 'ra'; last SWITCH; };
      /d/ && do { $mech = 'dec_drive'; last SWITCH; };

      /l/ && do { $cmd = $mech . "_to_limit"; $tc->$cmd; last SWITCH; };

      /j/ && do { $tc->ra_on( -(2**$ra_speed) ); sleep 1; $tc->ra_off;
	          last SWITCH; };
      /k/ && do { $tc->ra_on( 2**$ra_speed ); sleep 1; $tc->ra_off;
	          last SWITCH; };

      /m/ && do { $tc->ra_to_meridian; $tc->ra_off;
	          last SWITCH; };

      /b/ && do { --$ra_speed; printf "%d\n", 2**$ra_speed;
	          last SWITCH; };
      /n/ && do { ++$ra_speed; printf "%d\n", 2**$ra_speed;
	          last SWITCH; };

      /u/ && do { $tc->dec_drive_move_steps( -1 );
	          last SWITCH; };
      /i/ && do { $tc->dec_drive_move_steps( 1 );
	          last SWITCH; };

      /0/ && do { $tc->dec_drive_move_to_elev( 0 ); last SWITCH; };
      /1/ && do { $tc->dec_drive_move_to_elev( 45 ); last SWITCH; };
      /2/ && do { $tc->dec_drive_move_to_elev( 90 ); last SWITCH; };
      /3/ && do { $tc->dec_drive_move_to_elev( 135 ); last SWITCH; };

      /p/ && do { printf "RA %f DEC %d\n",
	                 $tc->ra_position,
	                 $tc->dec_drive_position;
                  last SWITCH; };
      }
   }
ReadMode 0;

$tc->dac_end;

undef $tc;
