#!/usr/bin/perl
#
# $Name:  $
#
# $Log: diag.pl,v $
# Revision 1.6  2005/04/17 04:12:48  robert
# *** empty log message ***
#
# Revision 1.5  2005/03/31 03:39:25  robert
# *** empty log message ***
#
# Revision 1.4  2005/03/22 03:09:20  robert
# *** empty log message ***
#
# Revision 1.3  2005/03/13 22:50:44  robert
# *** empty log message ***
#
# Revision 1.2  2005/02/11 02:31:18  robert
# Fix small bug where shutter was being closed twice.
#
# Revision 1.1  2005/01/16 03:36:50  robert
# *** empty log message ***
#
# Revision 0.1.1.1  2002/11/03 02:53:17  robert
#
#

use strict;
use warnings;

use Log::Agent;
use Log::Agent::Rotate;
use Log::Agent::Priorities qw( :LEVELS );
require Log::Agent::Driver::File;
require Log::Agent::Tag::Callback;
use Time::HiRes qw( time gettimeofday sleep tv_interval );
use IO;

my %adcs = (
             0  => "Water Temp   ",
             1  => "VCO Temp     ",
             2  => "VCO Reference",
             3  => "Temp 1       ",
             4  => "Temp 2       ",
             5  => "Temp 3       ",
             6  => "Temp C0 DAC15",
             7  => "Temp C3 DAC10",
             8  => "Ground       ",
             9  => "-15          ",
             10 => "-5           ",
             11 => "+5           ",
             12 => "+15          ",
             13 => "VCO     DAC12",
             14 => "Temp C1 DAC14",
             15 => "Temp C2 DAC11",
             16 => "CCD Temp 2   ",
             17 => "CCD VDD Power",
             18 => "CCD Temp 0   ",
             19 => "CCD Temp 1   ",
             20 => "ADC Reference",
             21 => "VVH     DAC 7",
             22 => "VRH     DAC 2",
             23 => "VHL     DAC 1",
             24 => "TEC Current 2",
             25 => "TEC Current 0",
             26 => "TEC Current 1",
             27 => "TEC Current 3",
             28 => "TEC Power    ",
             29 => "VVL     DAC 6",
             30 => "VRL     DAC 3",
             31 => "VHH     DAC 0"
);

logconfig(
           -driver => Log::Agent::Driver::File->make(
                                 -prefix  => 'diag',
                                 -showpid => 1,
                                 -rotate  => Log::Agent::Rotate->make(
                                                         -unzipped => 3,
                                                         -backlog  => 3,
                                                         -max_size => 1_000_000,
                                 ),
                                 -channels => {
                                                'error'  => 'diag.out',
                                                'output' => 'diag.out',
                                                'debug'  => 'diag.out'
                                 }
           ),
           -level => DEBUG
);

use TASS::Control;
my $tc = TASS::Control->new( './tass-control.cfg' );

$tc->start;
$tc->init_telescope;
$tc->chiller_off;

print "Taking dark picture\n";
$tc->take_dark_pictures( 1, 10 );

print "Taking object picture\n";
$tc->take_object_pictures( 1, 10 );

exit;

for ( 1..10 )
   {
   for my $shutter ( 0..1 )
      {
      my $open = sprintf "shutter_%d_open", $shutter;
      my $close = sprintf "shutter_%d_close", $shutter;
      print "Opening shutter $shutter ";
      eval { $tc->$open };
      if ( $@ )
         {
         print "Failed";
         }
      else
         {
         print "Passed";
         }
      print "\n";
      print "Closing shutter $shutter ";
      eval { $tc->$close };
      if ( $@ )
         {
         print "Failed";
         }
      else
         {
         print "Passed";
         }
      print "\n";
      }
   }

exit;

$tc->take_object_pictures( 2, 50, -30 );

exit;

#$tc->dac_start;
#my @first = map { ($tc->driver->read_adc( $_ ))[1] } 0..31;

#$tc->dac_end;
#my @second = map { ($tc->driver->read_adc( $_ ))[1] } 0..31;

#for ( 0..31 )
#   {
#   printf "%2d %s %7.2f %7.2f\n",
#          $_, $adcs{ $_ }, $first[ $_ ], $second[ $_ ];
#   }
#
print "Initializing focus 0\n";
$tc->driver->motor_setup( 'FOCUS_0', 'IN' );
$tc->driver->motor_off( 'FOCUS_0' );
$tc->clear_focus_0_motor_on;
$tc->focus_0_position( 0 );
eval { $tc->focus_0_to_limit; };
warn "Couldn't initilize focus 0\n" if ( $@ );
exit;

print "Initializing RA\n";
for ( 0 .. 6 )
   {
   $tc->ra_on( 2**$_ );
   sleep 5;
   }
for ( 0 .. 6 )
   {
   $tc->ra_on( -1 * 2**$_ );
   sleep 5;
   }
$tc->ra_to_limit;
exit;

print "Turning chiller on\n";
$tc->chiller_on;
sleep 2;
print "Turning chiller off\n";
$tc->chiller_off;

print "Initializing focus 1\n";
$tc->driver->motor_setup( 'FOCUS_1', 'IN' );
$tc->driver->motor_off( 'FOCUS_1' );
$tc->clear_focus_1_motor_on;
$tc->focus_1_position( 0 );
eval { $tc->focus_1_to_limit; };
warn "Couldn't initilize focus 1\n" if ( $@ );
exit;

$tc->clear_ccds;
$tc->clear_ccds;
print "Taking bias picture\n";
$tc->take_bias_pictures( 1 );
print "Taking dark picture\n";
$tc->take_dark_pictures( 1, 60 );
print "Taking object picture\n";
$tc->take_object_pictures( 1, 60 );
