#!/usr/bin/perl
#
# Takes a series of images at different focus locations to determine
# best focus
#
# $Name:  $
#
# $Log: focus.pl,v $
# Revision 1.3  2005/03/13 22:49:12  robert
# *** empty log message ***
#
# Revision 1.2  2005/01/16 03:33:19  robert
# *** empty log message ***
#
# Revision 1.1  2003/01/25 19:20:23  robert
# *** empty log message ***
#
# Revision 0.1.1.1  2002/11/03 02:53:17  robert
#
#

use strict;
use warnings;

use Time::HiRes qw(sleep gettimeofday tv_interval time);
use Log::Agent;
use Log::Agent::Rotate;
use Log::Agent::Priorities qw( :LEVELS );
use Log::Agent::Driver::File;

logconfig(
           -driver => Log::Agent::Driver::File->make(
                                 -prefix  => 'TC',
                                 -showpid => 1,
                                 -rotate  => Log::Agent::Rotate->make(
                                                         -unzipped => 3,
                                                         -backlog  => 3,
                                                         -max_size => 1_000_000,
                                 ),
                                 -channels => {
                                                'error'  => 'focus.out',
                                                'output' => 'focus.out',
                                                'debug'  => 'focus.out'
                                 }
           ),
           -level => INFO
);

use TASS::Control;
my $tc = TASS::Control->new( './tass-control.cfg' );

#
# Talk to the stamp and get everything setup to run
$tc->start;
$tc->init_telescope;
$tc->dac_start;

#
# Move to verticle so the focus won't bind
$tc->dec_drive_move_to_elev( 90 );
$tc->ra_to_meridian;

#
# Set the exposure length and focus step size
my $exp           = 60;
my $step          = 10;
my $images        = 5;
my $focus_0_start = $tc->focus_0_best;
my $focus_1_start = $tc->focus_1_best;

#
# Start off by taking bias and dark
#$tc->take_bias_pictures( 1 );
#$tc->take_dark_pictures( 1, $exp );

#
# Move the focus all the way in, then to the starting location
$tc->focus_0_to_limit;
$tc->focus_1_to_limit;
$tc->focus_0_move_steps( $focus_0_start - ( $images - 1 ) / 2 * $step );
$tc->focus_1_move_steps( $focus_1_start - ( $images - 1 ) / 2 * $step );

#
# Clear out the CCD's twice to make sure they are 'empty'
for ( 1 .. 2 ) { $tc->clear_ccds; }

#
# Start tracking
$tc->ra_on;

for ( 1 .. $images )
   {

   #
   # Take the required picture, back tracking 1/2 the expsoure length on
   # RA when done.  This keeps RA verticle
   $tc->take_object_pictures( 1, $exp, -$exp / 2 );
   printf "0 = %d 1 = %d\n", $tc->focus_0_position, $tc->focus_1_position;

   #
   # Move the next step out
   $tc->focus_0_move_steps( $step );
   $tc->focus_1_move_steps( $step );
   }

#
# All done...
$tc->ra_off;

undef $tc;
