#!/usr/bin/perl
#
# $Name:  $
#
# $Log: night_track.pl,v $
# Revision 1.4  2005/04/17 04:13:06  robert
# *** empty log message ***
#
# Revision 1.3  2005/03/31 03:38:38  robert
# *** empty log message ***
#
# Revision 1.2  2005/03/22 03:09:20  robert
# *** empty log message ***
#
# Revision 1.1  2005/03/13 22:50:44  robert
# *** empty log message ***
#
# Revision 1.1  2003/01/25 19:20:23  robert
# *** empty log message ***
#
# Revision 0.1.1.1  2002/11/03 02:53:17  robert
#
#

use strict;
use warnings;

use Time::HiRes qw(sleep gettimeofday tv_interval time);
use Log::Agent;
use Log::Agent::Rotate;
use Log::Agent::Priorities qw( :LEVELS );
use Log::Agent::Driver::File;
use Astro::Sunrise;
use Class::Date qw( date localdate );

logconfig(
   -driver => Log::Agent::Driver::File->make(
      -prefix  => 'TC',
      -showpid => 1,
      -rotate  => Log::Agent::Rotate->make(
                                           -unzipped => 3,
                                           -backlog  => 9,
                                           -max_size => 10_000_000,
      ),

      #-channels => { 'error' => 'night.err',
      #    'output' => 'night.out',
      #    'debug' => 'night.dbg' } ),
      -channels => {
                     'error'  => 'night_track.out',
                     'output' => 'night_track.out',
                     'debug'  => 'night_track.out'
      }
   ),
   -level => INFO
);

my $exp = 90;
my $loc = 64;
my $trans  = 48.91;
my $polar = 0;

use TASS::Control;
my $tc = TASS::Control->new( './tass-control.cfg' );

my $sun_set = sun_set( $tc->longitude, $tc->latitude, -18 );
my $sun_rise = sun_rise( $tc->longitude, $tc->latitude, -18, 1 );
my $tz = `date "+%Z"`;
chomp $tz;
my $tzoffset = `date "+%z"`;
chomp $tzoffset;
my $now = date( `date "+%Y-%m-%d %H:%M:%S"`, $tz );

$Class::Date::DATE_FORMAT = '%Y-%m-%d';
my $set_time  = date( "$now $sun_set",  $tz );
my $rise_time = date( "$now $sun_rise", $tz );
$Class::Date::DATE_FORMAT = undef;              #'%Y-%m-%d %H:%M:%S';
$rise_time                = $rise_time + '1D';

#printf 'Set: %s Rise: %s', $set_time, $rise_time;
#printf 'setting in %d seconds - rising in %d seconds total %d',
#   $set_time - $now, $rise_time - $now, $rise_time - $set_time;
#exit;

logtrc INFO, 'Set: %s Rise: %s', $set_time, $rise_time;

logtrc INFO, 'setting in %d seconds - rising in %d seconds total %d',
   $set_time - $now, $rise_time - $now, $rise_time - $set_time;

$now = date( `date "+%Y-%m-%d %H:%M:%S"`, $tz );
logtrc INFO, 'Setting up telescope';
$tc->start;
$tc->dac_start;
$tc->init_telescope;

$tc->ra_to_meridian;

if ( ( ( $set_time - $now ) - 3600 ) > 0 )
   {
   logtrc INFO, 'Sleeping for %d seconds', ( $set_time - $now ) - 3600;
   $tc->delay( ( $set_time - $now ) - 3600 );
   }

if (  ($tc->focus_0_position != $tc->focus_0_best)
   || ($tc->focus_1_position != $tc->focus_1_best)
   )
   {
   $tc->dec_drive_move_to_elev( 90 );
   $tc->focus_0_to_limit;
   $tc->focus_1_to_limit;

   #$tc->focus_0_move_steps( $tc->focus_0_best );
   #$tc->focus_1_move_steps( $tc->focus_1_best );
   $tc->focus_0_move_to_position( $tc->focus_0_best );
   $tc->focus_1_move_to_position( $tc->focus_1_best );
   }

if ( ( $set_time - $now ) > 0 )
   {
   if ( $polar )
      {
      $tc->dec_drive_move_to_degree( 90 );
      for ( 1 .. 2 ) { $tc->clear_ccds; }
      $tc->ra_on;
      $tc->take_object_pictures( 16, $exp, -$exp / 2 );
      $tc->ra_off;
      }

   $now = date( `date "+%Y-%m-%d %H:%M:%S"`, $tz );
   logtrc INFO, 'Waiting for %d seconds', $set_time - $now;
   $tc->delay( $set_time - $now ) if ( $set_time - $now > 0 );
   }

$tc->dec_drive_move_to_degree( $loc );
for ( 1 .. 2 ) { $tc->clear_ccds; }

my $pic_set = -1;
my $rise_offset = sprintf "%ds", $exp + $trans;

$tc->ra_to_meridian( -$exp / 2 );
$tc->ra_on;
while ( ( $rise_time - $rise_offset ) >
        ( $now = date( `date "+%Y-%m-%d %H:%M:%S"`, $tz ) ) )
   {
   logtrc INFO, 'Working on pic %d - %d seconds left', ++$pic_set,
      $rise_time - $now;

   $tc->take_dark_pictures( 1, $exp )
      if ! ($pic_set % 18);

   #
   # Jitter off
   $tc->take_object_pictures( 1, $exp, -$exp / 2 );
   }

$tc->ra_on( -1 );
$tc->take_dark_pictures( 12, $exp );
$tc->take_bias_pictures( 12 );

$tc->ra_move_second( 100 );
$tc->ra_to_limit;
$tc->ra_to_meridian( 4 );
$tc->dec_drive_move_to_elev( 5 );
$tc->dec_drive_to_limit;
$tc->dec_drive_move_to_elev( 0 );

$tc->dac_end;

undef $tc;
