#!/usr/bin/perl
#
# Used to print out the current RA/DEC for a bit and then determine how
# far from home we were
#
# $Name:  $
#
# $Log: ra_dec.pl,v $
# Revision 0.2  2005/01/16 03:32:38  robert
# *** empty log message ***
#
# Revision 0.1.1.1  2002/11/03 02:53:17  robert
#
#

use warnings;
use strict;

use Astro::Time;
use Time::HiRes qw( sleep gettimeofday tv_interval time );
use TASS::Control;
use Log::Agent;
use Log::Agent::Priorities qw( :LEVELS );
require Log::Agent::Driver::File;
require Log::Agent::Tag::Callback;

logconfig(
           -driver => Log::Agent::Driver::File->make(
                                     -prefix   => 'TC',
                                     -showpid  => 1,
                                     -channels => {
                                                    'error'  => 'ra_dec.err',
                                                    'output' => 'ra_dec.out',
                                                    'debug'  => 'ra_dec.dbg'
                                     }
           ),
           -debug => INFO
);

my $tc = TASS::Control->new( '/tass/data/daily/tass-control.cfg' );

$tc->start;

$tc->init_telescope;

$tc->ra_on;

for my $elev ( 0 .. 10 )
   {
   $tc->dec_drive_move_elev_rel( $elev );
   $tc->ra_to_meridian( undef, 32 );
   printf "%2d %s %.2f\n", $elev, $tc->ra_current_hour,
      $tc->dec_drive_current_degree;
   for ( 1 .. 6 )
      {
      $tc->delay( 10 );
      printf "\t%s %.2f\n", $tc->ra_current_hour, $tc->ra_current_degree;
      }
   }
printf "ra off by %6.2f seconds\n", $tc->ra_to_limit();
printf "dec off by %d steps\n",     $tc->dec_drive_to_limit();
