#
# $Name:  $
#
# $Log: Server.pm,v $
# Revision 0.2  2002/12/23 04:01:30  robert
# *** empty log message ***
#
# Revision 0.1.1.1  2002/11/03 02:53:17  robert
#
#
package TASS::Control::Server;
@ISA = qw( RPC::PlServer );

use 5.006;
use strict;
use warnings;

use TASS::Control;
use RPC::PlServer;
use File::Spec;

use Log::Agent;
require Log::Agent::Driver::File;
require Log::Agent::Tag::Callback;

my $ID = q$Id: Server.pm,v 0.2 2002/12/23 04:01:30 robert Exp $;
my $version = join ( ' ', ( split ( ' ', $ID ) )[ 1 .. 3 ] );
$version =~ s/,v\b//;
$version =~ s/(\S+)$/($1)/;
our $VERSION = $version;

$TASS::Control::Server::VERSION = $VERSION;

=begin testing

BEGIN{ use_ok( 'TASS::Control::Server' ); }

=end testing

=head1 NAME

TASS::Control::Server - A perl modules which, in conjunction with
TASS::Control.pm and TASS::Control::Driver, implements user level control over a TASS IV telescope.
No workie right now.  Nothing done.

=cut

   {
   logconfig( -driver => Log::Agent::Driver::File->make(
                            -prefix => 'TS',
                            -showpid => 1,
                            -channels => { 'error' => 'eyes.err',
                                           'output' => 'eyes.out',
                                           'debug' => 'eyes.dbg' } ),
              -debug => 5
            );
   eval
      {
      my %DEFAULT_SERVER_OPTIONS;
      my $o = \%DEFAULT_SERVER_OPTIONS;

      $o->{'chroot'}     = undef,
      $o->{'clients'} =
	   [ { 'mask' => '.*',
	       'accept' => 1,
	       'cipher' => undef
	       }
	     ];
      $o->{'configfile'} = '/etc/tass_srv.conf' if -f '/etc/tass_srv.conf';
      $o->{'debug'}      = 0;
      $o->{'facility'}   = 'daemon';
      $o->{'group'}      = undef;
      $o->{'localaddr'}  = undef;		# Bind to any local IP number
      $o->{'localport'}  = 9876;
      $o->{'logfile'}    = undef;         # Use syslog or EventLog.
	   $o->{'mode'}       = 'single';
      $o->{'pidfile'}    = '/tmp/tass_srv.pid';
      $o->{'user'}       = undef;
      $o->{ 'methods' } = {
         'TASS::Control::Server' => {
               'NewHandle' => 1,
               'CallMethod' => 1
            },
         'TASS::Control' => {
               'new' => 1,
            }
         };

      my $server = TASS::Control::Server->new( \%DEFAULT_SERVER_OPTIONS, \@_ );
      $server->Bind;
      };
   }

1;
__END__
