#!/usr/bin/perl
#
# Runs the scope for an hour monitoring the chiller and temp's every minute
#
# $Name:  $
#
# $Log: chiller.pl,v $
# Revision 0.2  2005/01/16 03:34:09  robert
# *** empty log message ***
#
# Revision 0.1.1.1  2002/11/03 02:53:17  robert
#
#

use strict;
use warnings;

use Log::Agent;
use Log::Agent::Rotate;
use Log::Agent::Priorities qw( :LEVELS );
require Log::Agent::Driver::File;
require Log::Agent::Tag::Callback;
use Time::HiRes qw( time gettimeofday sleep tv_interval );
use IO;

logconfig(
           -driver => Log::Agent::Driver::File->make(
                                -prefix  => 'chiller',
                                -showpid => 1,
                                -rotate  => Log::Agent::Rotate->make(
                                                        -unzipped => 3,
                                                        -backlog  => 3,
                                                        -max_size => 10_000_000,
                                ),
                                -channels => {
                                               'error'  => 'chiller.out',
                                               'output' => 'chiller.out',
                                               'debug'  => 'chiller.out'
                                }
           ),
           -level => INFO
);

use TASS::Control;
my $tc = TASS::Control->new( './tass-control.cfg' );

#
# Starts up communication with the stamp
$tc->start;

#
# Starts the dac with the configured values
$tc->dac_start;

#
# Makes sure the scope is initialized.
$tc->init_telescope;

my @adc = ( 0, 1, 4, 5, 18, 19, 25, 26 );
my $out;

#
# Spits out the initial data
for ( @adc )
   {
   my ( $status, $temp ) = $tc->driver->read_adc( $_ );
   die if !$status;
   $out .= sprintf "%.2f ", $temp;
   }
printf "$out\n";

#
# Open up the file to be used to keep the data
open FILE, ">chiller.dat";
FILE->autoflush;
my $start = [ gettimeofday ];
for ( 1 .. 60 * 2 )
   {

   #
   # Yack out the chiller state and the time passed
   $out = sprintf "%d %d ", $tc->_chiller_on, tv_interval( $start );

   #
   # Put the info into the the file and to the screen
   for ( @adc )
      {
      my ( $status, $temp ) = $tc->driver->read_adc( $_ );
      die if !$status;
      $out .= sprintf "%.2f ", $temp;
      }
   printf FILE "$out\n";
   printf "$out\n";
   $tc->delay( 60 );
   }
$tc->chiller_off;
printf "Chiller on time  %9.2f\n", $tc->_chiller_time_on;
printf "Chiller off time %9.2f\n", $tc->_chiller_time_off;

close FILE;

#
# Re-set the dac values per the config file
$tc->dac_end;
undef $tc;
