#!/usr/bin/perl
#
# Re-determines home positions for RA/DEC and moves to a 'parked' position
#
# $Name:  $
#
# $Log: park.pl,v $
# Revision 1.2  2005/03/13 22:50:01  robert
# *** empty log message ***
#
# Revision 1.1  2005/01/16 03:36:51  robert
# *** empty log message ***
#
# Revision 1.1  2003/01/25 19:20:23  robert
# *** empty log message ***
#
# Revision 0.1.1.1  2002/11/03 02:53:17  robert
#
#

use strict;
use warnings;

use Time::HiRes qw(sleep gettimeofday tv_interval time);
use Log::Agent;
use Log::Agent::Rotate;
use Log::Agent::Priorities qw( :LEVELS );
use Log::Agent::Driver::File;
use Astro::Sunrise;
use Class::Date qw( date localdate );

logconfig(
           -driver => Log::Agent::Driver::File->make(
                                 -prefix  => 'TC',
                                 -showpid => 1,
                                 -rotate  => Log::Agent::Rotate->make(
                                                         -unzipped => 3,
                                                         -backlog  => 3,
                                                         -max_size => 1_000_000,
                                 ),
                                 -channels => {
                                                'error'  => 'park.out',
                                                'output' => 'park.out',
                                                'debug'  => 'park.out'
                                 }
           ),
           -level => INFO
);

use TASS::Control;
my $tc = TASS::Control->new( './tass-control.cfg' );

$tc->start;
$tc->init_telescope;
$tc->dec_drive_move_to_elev( 5 );
$tc->dec_drive_to_limit;
$tc->dec_drive_move_to_elev( 0 );
$tc->ra_move_second( 100 );
$tc->ra_to_limit;
$tc->ra_to_meridian( 4 );
exit;
