#!/usr/bin/perl
#
# Used to just shutdown the scope.  Good for when something bad has happened
#
# $Name:  $
#
# $Log: stop.pl,v $
# Revision 0.2  2005/01/16 03:31:33  robert
# *** empty log message ***
#
# Revision 0.1.1.1  2002/11/03 02:53:17  robert
#
#

use warnings;
use strict;

use Astro::Time;
use Time::HiRes qw( sleep gettimeofday tv_interval );
use TASS::Control;
use Log::Agent;
use Log::Agent::Rotate;
use Log::Agent::Priorities qw( :LEVELS );
require Log::Agent::Driver::File;
require Log::Agent::Tag::Callback;

logconfig(
           -driver => Log::Agent::Driver::File->make(
                                    -prefix  => 'TD',
                                    -showpid => 1,
                                    -rotate  => Log::Agent::Rotate->make(
                                                            -unzipped => 3,
                                                            -backlog  => 3,
                                                            -max_size => 10_000,
                                    ),
                                    -channels => {
                                                   'error'  => 'stop.out',
                                                   'output' => 'stop.out',
                                                   'debug'  => 'stop.out'
                                    }
           ),
           -level => DEBUG
);

my $tc = TASS::Control->new;

$tc->start;
$tc->dac_end;
