#!/usr/bin/perl
#
# Spits out the sun rise/set based on the configured location
# $Name:  $
#
# $Log: sun_set_rise.pl,v $
# Revision 0.3  2005/06/23 03:23:53  robert
# *** empty log message ***
#
# Revision 0.2  2005/01/16 03:30:58  robert
# *** empty log message ***
#
# Revision 0.1.1.1  2002/11/03 02:53:17  robert
#
#

use warnings;
use strict;

use Astro::Sunrise;
use Class::Date qw( date localdate -DateParse );

use TASS::Control;
my $tc = TASS::Control->new( './tass-control.cfg' );

my ( $now, $sun_rise, $sun_set, $temp );

$sun_set  = sun_set( $tc->longitude, $tc->latitude, -18 );
$sun_rise = sun_rise( $tc->longitude, $tc->latitude, -18, 1 );

print "$sun_set to $sun_rise\n";

my $tz = `date "+%Z"`;
chomp $tz;

my $tzoffset = `date "+%z"`;
chomp $tzoffset;
$tzoffset /= 100;

$now = localdate( `date` );

$Class::Date::DATE_FORMAT = '%Y-%m-%d';
my $set  = date "$now $sun_set",  $tz;
my $rise = date "$now $sun_rise", $tz;
$Class::Date::DATE_FORMAT = undef;

$rise = $rise + '1D';
printf "%s\n",         $now;
printf " sets at %s in %.1f hours\n",  $set, ( $set - $now ) / 3600;
printf "rises at %s in %.1f hours\n", $rise, ( $rise - $now ) / 3600;
