//
// outb: software to write a byte to a port address
// Copyright (C) 2003-2004  Robert S. Creager
//
// E-mail: Robert_Creager@LogicalChaos.org
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// $Name:  $
//
// $Log: outb.c,v $
// Revision 1.2  2004/06/13 20:50:34  robert
// Add copyright header
//
//                                                                         

#include <sys/io.h>

int
main(
   int argc,
   char *argv[] )
{
   unsigned port;
   unsigned value;
   int x;

   sscanf( argv[1], "0x%x", &port );

   /* Grant port permissions - need suid root privy */
   if ( ioperm( port, 1, 1 ) )
      {
         printf
            ( "Cannot get read privledges for port 0x%03X - is suid root set?\n",
              port );
         perror( "ioperm" );
         exit( 1 );
      }

   for ( x = 2; x < argc; ++x )
      {
         sscanf( argv[x], "0x%x", &value );
         outb( value, port );
         usleep( 10 );
      }

   /* Remove port access permissions */
   if ( ioperm( port, 1, 0 ) )
      {
         printf
            ( "Cannot release read privledges for port 0x300 - is suid root set?\n" );
         perror( "ioperm" );
         exit( 1 );
      }
   exit( 0 );
}
